<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('scheduled_visits', function (Blueprint $table) {
            $table->id();
            $table->string('visitor_name');
            $table->string('visitor_email')->nullable();
            $table->string('visitor_phone');
            $table->string('company_name');
            $table->string('purpose');
            $table->foreignId('host_id')->constrained('staff')->onDelete('cascade');
            $table->date('scheduled_date');
            $table->time('scheduled_time');
            $table->enum('status', ['scheduled', 'checked_in', 'cancelled', 'no_show'])->default('scheduled');
            $table->foreignId('check_in_id')->nullable()->constrained('visitors')->onDelete('set null');
            $table->text('notes')->nullable();
            $table->string('confirmation_token')->unique()->nullable();
            $table->timestamps();
            
            $table->index(['scheduled_date', 'scheduled_time']);
            $table->index('status');
            $table->index('host_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('scheduled_visits');
    }
};
