<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Staff extends Model
{
    protected $fillable = [
        'name',
        'department',
        'email',
    ];

    /**
     * Get the visitors for this staff member.
     */
    public function visitors(): HasMany
    {
        return $this->hasMany(Visitor::class, 'host_id');
    }
}
